CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'rc_vd_conv_cred') THEN 
        CREATE TABLE rc_vd_conv_cred (
            cd_emp bigint not null default 0,
			cd_ctr bigint not null default 0,
			cd_ctr_cred bigint not null default 0,
			dt_cred timestamp null,
			vlr_cred numeric(14, 4) not null default 0,
			CONSTRAINT rc_vd_conv_cred_pkey PRIMARY KEY (cd_emp,cd_ctr,cd_ctr_cred),
			CONSTRAINT rc_vd_conv_cred_rc_vd_conv_fkey FOREIGN KEY (cd_emp,cd_ctr) REFERENCES rc_vd_conv(cd_emp,cd_ctr)
        )
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA rc_vd_conv_cred %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();